//+------------------------------------------------------------------+
//|                                                (Shu)-AccInfo.mq4 |
//|                                                             `Shu |
//|                                            http://SovetnikShu.ru |
//+------------------------------------------------------------------+
#property copyright "`Shu"
#property link      "http://SovetnikShu.ru"

#property indicator_separate_window

extern int Months = 3;
extern int Weeks  = 6;


extern color clr.Head = Aqua;
extern color clr.Good = Lime;
extern color clr.Baad = Red;

int win;

string shu = " [1.02] (c) `Shu [http://SovetnikShu.ru]";
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
   Print(WindowExpertName() + shu);

return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit() {
return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int i;
   int limit;
   int bs;
   double d;
   datetime dt;
   string s;

   IndicatorShortName.shu("(Shu)-AccInfo: " + AccountNumber() + " " + AccountCompany());   

   ccc(win, "");
   ccc(win, ": "   + ns0(AccountNumber()),  clr.Head, 0, 20, 20, 20);
   ccc(win, ": " + ns2(AccountBalance()), clr.Good);
   ccc(win, ": " + ns2(AccountEquity()),  clr.Good);
   
   d = Result(0, TimeCurrent() + 1);
   s = ": " + ns2(d);
   ccc(win, s, iif(d >= 0, clr.Good, clr.Baad));    
   
   ccc(win, ": ", clr.Head, 0, 160, 20, 0);
   
   for (i = 0; i > -Months; i--) {
      dt = StartMonth(TimeCurrent(), i);   
      d = Result(dt, StartMonth(dt, 1) - 1);
      s = MonthTxt(TimeMonth(dt)) + ": " + ns2(d);
      ccc(win, s, iif(d >= 0, clr.Good, clr.Baad));      
   }

   ccc(win, ": ", clr.Head, 0, 300, 20, 0);

   for (i = 0; i > -Weeks; i--) {
      dt = StartWeek(TimeCurrent(), i);   
      d = Result(dt, StartWeek(dt, 1) - 1);
      s = TimeToStr(dt, TIME_DATE) + ": " + ns2(d);
      ccc(win, s, iif(d >= 0, clr.Good, clr.Baad));    
   }

return(0);
}
//+------------------------------------------------------------------+
void ccc(int wn = 0, string txt = "", color clr = Green, int cr = 0, int X = 0, int Y = 0, int stp = 0, string font = "Tahoma", int fs = 10) {
   static int num = 0;
   static int x, y;
   static int step = 10;
   int i;
   int x0 = 0, y0 = 0;
   string on, n;

   on = "ccc" + "." + wn;
   
   if (txt == "") {
      x = x0;
      y = y0;
      num = 0;
      for (i = ObjectsTotal() - 1; i >= 0 ; i--) {
         n = ObjectName(i);
         if (ObjectType(n) != OBJ_LABEL) continue;
         if (StringFind(n, on) != -1) ObjectDelete(n);
      }   
      return;
   }
   
   if (stp > 0) step = stp;
   
   if ((X <  0) || (Y <  0)) {x = x0; y = y0;} 
   if ((X >  0) || (Y >  0)) {x = X;  y = Y; } 
   
   on = on + "." + num;
   
   ObjectCreate(on, OBJ_LABEL, wn, 0, 0);
   ObjectSet   (on, OBJPROP_CORNER, cr);
   ObjectSet   (on, OBJPROP_XDISTANCE, x);
   ObjectSet   (on, OBJPROP_YDISTANCE, y);
   ObjectSet   (on, OBJPROP_COLOR, clr);
   ObjectSetText(on, txt, fs, font, clr);
   
   num++;
   y = y + step;
   
return;
}
//+------------------------------------------------------------------+
string ns2(double ) {
   return(DoubleToStr(, 2));
}
//+------------------------------------------------------------------+
string ns0(double ) {
   return(DoubleToStr(, 0));
}
//+------------------------------------------------------------------+
void IndicatorShortName.shu(string s) {
   IndicatorShortName(s);
   win = WindowFind(s);
return; 
}
//+------------------------------------------------------------------+
string MonthTxt(int m) {
   string r;
   switch (m) {
      case  1:  r = "";    break;
      case  2:  r = "";   break;
      case  3:  r = "";      break;
      case  4:  r = "";    break;
      case  5:  r = "";       break;
      case  6:  r = "";      break;
      case  7:  r = "";      break;
      case  8:  r = "";    break;
      case  9:  r = "";  break;
      case 10:  r = "";   break;
      case 11:  r = "";    break;
      case 12:  r = "";   break;
      default:  r = "---";
   }
return(r);
}
//+------------------------------------------------------------------+
double Result(datetime dt1, datetime dt2) {
   int i;
   double r;
   
   r = 0;
   for (i = 0; i < OrdersHistoryTotal(); i++) {
      if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY)) {
         if (OrderClosePrice() == 0) continue;
         if ((OrderCloseTime() < dt1) || (OrderCloseTime() > dt2)) continue;
         r = r + OrderProfit() + OrderCommission() + OrderSwap();
      }
   }
return(r);   
}
//+------------------------------------------------------------------+
datetime StartMonth(datetime dt = 0, int shift = 0) {
   int i, y, m;
   if (dt == 0) dt = TimeCurrent();
   
   y = TimeYear(dt);
   m = TimeMonth(dt);
   while (shift != 0) {
      if (shift > 0) {
         shift--;
         m++;
         if (m > 12) {
            m = 1;
            y++;
         }
      }
      if (shift < 0) {
         shift++;
         m--;
         if (m < 1) {
            m = 12;
            y--;
         }
      }
   }
   
   dt = StrToTime(y + "." + m + ".1");
   
return(dt);   
}
//+------------------------------------------------------------------+
// *   
datetime StartWeek(datetime dt, int shift = 0) {
   datetime r;

   r = dt + shift * PERIOD_W1 * 60;
   
   r = r / (PERIOD_D1 * 60);
   r = r  * (PERIOD_D1 * 60);                       // -     
   
   switch(TimeDayOfWeek(r)) {
      case 1:  break;
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
               r = r - (PERIOD_D1 * 60) * (TimeDayOfWeek(r) - 1);
               break;
      case 0:
               r = r - (PERIOD_D1 * 60) * 6;
               break;
   }
   
return(r);   
}
//+------------------------------------------------------------------+
//   DOUBLE (!)
double iif(bool , double , double ) {
   if ()      return();
               else  return();
}
//+------------------------------------------------------------------+

